% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmt2list.R
\name{gmt2list}
\alias{gmt2list}
\title{gmt2list: Convert GMT File to Named List}
\usage{
gmt2list(file, verbose = TRUE)
}
\arguments{
\item{file}{Character. Path to a .gmt file.}

\item{verbose}{Logical. Whether to print message. Default is TRUE.}
}
\value{
A named list where each element is a character vector of gene symbols.
}
\description{
Reads a .gmt gene set file and returns a named list,
where each list element is a gene set.
}
\examples{
\dontrun{
# Requires a GMT file to run:
gmt_file <- "path/to/geneset.gmt"
gene_sets <- gmt2list(gmt_file)
length(gene_sets)
names(gene_sets)[1:3]
}

}
