% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/URATE.R
\name{URATE}
\alias{URATE}
\title{This function use individualized treatment rule  to identify exceptional responders. The details of the methods for this design are given in Imai and Li (2023).}
\usage{
URATE(D, tau, Y)
}
\arguments{
\item{D}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A vector of the unit-level continuous score. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{A vector of the outcome variable of interest for each sample.}
}
\value{
A list that contains the following items: \item{rate}{The estimated
vector of URATE of length \code{Y}.} \item{sd}{The estimated vector of standard deviation of URATE.}
}
\description{
This function use individualized treatment rule  to identify exceptional responders. The details of the methods for this design are given in Imai and Li (2023).
}
\examples{
D <- c(1, 0, 1, 0, 1, 0, 1, 0)
tau <- c(0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7)
Y <- c(4, 5, 0, 2, 4, 1, -4, 3)
ratelist <- URATE(D, tau, Y)
ratelist$rate
ratelist$sd
}
\references{
Imai and Li (2022). \dQuote{Statistical Inference for Heterogeneous Treatment Effects Discovered by Generic Machine Learning in Randomized Experiments},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{band}
\keyword{uniform}
