% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizSection.R
\name{VizSection}
\alias{VizSection}
\title{Plots A Vertical Section}
\usage{
VizSection(
  data,
  horiz,
  depth,
  toptitle = "",
  title_scale = 1,
  sizetit = NULL,
  units = "",
  brks = NULL,
  cols = NULL,
  axelab = TRUE,
  intydep = 200,
  intxhoriz = 20,
  drawleg = TRUE,
  fileout = NULL,
  width = 10,
  height = 8,
  size_units = "in",
  res = 100,
  var = NULL,
  ...
)
}
\arguments{
\item{data}{Matrix to plot with (longitude/latitude, depth) dimensions.}

\item{horiz}{Array of longitudes or latitudes.}

\item{depth}{Array of depths.}

\item{toptitle}{Title, optional.}

\item{title_scale}{Scale factor for the figure top title. Defaults to 1.}

\item{sizetit}{Deprecated. Use 'title_scale' instead.}

\item{units}{Units, optional.}

\item{brks}{Colour levels, optional.}

\item{cols}{List of colours, optional.}

\item{axelab}{TRUE/FALSE, label the axis. Default = TRUE.}

\item{intydep}{Interval between depth ticks on y-axis. Default: 200m.}

\item{intxhoriz}{Interval between longitude/latitude ticks on x-axis.\cr
Default: 20deg.}

\item{drawleg}{Draw colorbar. Default: TRUE.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. \cr
Default = NULL}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{var}{Deprecated. Use 'data' instead.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
adj ann ask bg bty cex.lab cex.sub cin col.axis col.lab col.main col.sub 
cra crt csi cxy err family fg fig fin font font.axis font.lab font.main 
font.sub lend lheight ljoin lmitre lty lwd mex mfcol mfrow mfg mkh oma omd 
omi page pch pin plt pty smo srt tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs 
yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
A figure in popup window by default, or saved to the specified path
 via \code{fileout}.
}
\description{
Plot a (longitude,depth) or (latitude,depth) section.
}
\examples{
# Synthetic data
data <- array(rep(seq(25, 10, length.out = 7), each = 21) - rnorm(147),
              dim = c(lat = 21, depth = 7))
VizSection(data, horiz = 0:20, depth = seq(0, 300, length.out = 7),
           toptitle = 'Temperature cross-section', units = "degC")

}
