% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_meta_diamond.R
\name{geom_meta_diamond_h}
\alias{geom_meta_diamond_h}
\title{Meta-analysis diamond}
\usage{
geom_meta_diamond_h(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed to the geom. These are often aesthetics,
used to set an aesthetic to a fixed value, like \code{colour = "red"} or
\code{linewidth = 3} (see \strong{Aesthetics}, below).

##Aesthetics ##
\code{geom_meta_diamond_h} understands the following aesthetics (required are
in bold):
\itemize{
\item \strong{\code{x}} - The horizontal center of the diamond
\item \strong{\code{y}} - The vertical placement of the diamond
\item \strong{\code{xmin}} - The left-side start of the diamond
\item \strong{\code{xmax}} - The right-side start of the diamond
\item \strong{\code{height}} - The vertical span of the diamond
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
\code{geom_meta_diamond_h} creates a horizontal meta-analytic diamond
defined by an \code{x} value (horizontal center of diamond), \code{xmin} and \code{xmax}
values (for the horizontal ends of the diamond), a \code{y} value (for the
vertical placement of the diamond) and a \code{height} (for the vertical height
of the diamond).  Note the use of \code{xmin} and \code{xmax} allows for representation
of asymmetric confidence intervals with this geom.
}
\examples{
# example code
library(ggplot2)

my_effects <- data.frame(
  effect_size = c(1, 2, 1, 0),
  UL = c(2, 3, 2, 1),
  LL = c(0, 1, 0, -1),
  y = c(1, 2, 3, 4)
)


myplot <- ggplot2::ggplot()
myplot <- myplot + geom_meta_diamond_h(
  data = my_effects,
  ggplot2::aes(
    x = effect_size,
    xmin = LL,
    xmax = UL,
    y = y
  ),
  height = 0.25,
  color = "black",
  fill = "red",
)


}
