% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate-package.R
\docType{package}
\name{equate-package}
\alias{equate-package}
\title{equate: Observed-Score Linking and Equating}
\description{
Contains methods for observed-score linking and equating under the single-group, equivalent-groups, and nonequivalent-groups with anchor test(s) designs. Equating types include identity, mean, linear, general linear, equipercentile, circle-arc, and composites of these. Equating methods include synthetic, nominal weights, Tucker, Levine observed score, Levine true score, Braun/Holland, frequency estimation, and chained equating. Plotting and summary methods, and methods for multivariate presmoothing and bootstrap error estimation are also provided.

Contains methods for observed-score linking and equating under the
single-group, equivalent-groups, and nonequivalent-groups with anchor
test(s) designs. Equating types include identity, mean, linear, general
linear, equipercentile, circle-arc, and composites of these. Equating
methods include synthetic, nominal weights, Tucker, Levine observed score,
Levine true score, Braun/Holland, frequency estimation, and chained
equating. Plotting and summary methods, and methods for multivariate
presmoothing and bootstrap error estimation are also provided.
}
\details{
\tabular{ll}{ Package: \tab equate\cr Version: \tab 2.0.9\cr Date: \tab
2026-02-23\cr Depends: \tab R (>= 4.1.0)\cr License: \tab GPL-3\cr }

Index: \tabular{ll}{
ACTmath \tab ACT Mathematics Test Scores\cr
KBneat \tab Test Scores Under a NEAT design\cr
PISA \tab Programme for International Student Assessment 2009 USA Data\cr
descriptives \tab Descriptive Statistics for Frequency Tables\cr
percentiles \tab Percentile Ranks and Cumulative Frequencies for Frequency Tables\cr
equate \tab Observed Score Linking and Equating\cr
composite \tab Composite Linking and Equating\cr
bootstrap \tab Bootstrap Equating Error\cr
freqtab \tab Frequency Distribution Tables\cr
presmoothing \tab Frequency Distribution Presmoothing\cr
plot.freqtab \tab Plotting Frequency Distributions\cr
plot.equate \tab Plotting Equating Results\cr}

Further information is available in the following vignettes:
\tabular{ll}{
\code{equatevignette} \tab equate vignette (source, pdf)\cr }
The package vignette provides an introduction to linking and equating and includes
descriptions of the supported equating methods and examples. The help page
for the main function of the package, \code{\link{equate}}, contains
additional examples.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/talbano/equate}
  \item Report bugs at \url{https://github.com/talbano/equate/issues}
}

}
\author{
\strong{Maintainer}: Anthony Albano \email{tony.d.albano@gmail.com}


Anthony Albano <tony.d.albano@gmail.com>
}
\keyword{internal}
\keyword{package}
