% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfr.R
\name{attack_rate}
\alias{attack_rate}
\alias{case_fatality_rate}
\alias{case_fatality_rate_df}
\alias{mortality_rate}
\title{Rates and Ratios}
\usage{
attack_rate(
  cases,
  population,
  conf_level = 0.95,
  multiplier = 100,
  mergeCI = FALSE,
  digits = 2
)

case_fatality_rate(
  deaths,
  population,
  conf_level = 0.95,
  multiplier = 100,
  mergeCI = FALSE,
  digits = 2
)

case_fatality_rate_df(
  x,
  deaths,
  group = NULL,
  conf_level = 0.95,
  multiplier = 100,
  mergeCI = FALSE,
  digits = 2,
  add_total = FALSE
)

mortality_rate(
  deaths,
  population,
  conf_level = 0.95,
  multiplier = 10^4,
  mergeCI = FALSE,
  digits = 2
)
}
\arguments{
\item{cases, deaths}{number of cases or deaths in a population. For \verb{_df}
functions, this can be the name of a logical column OR an evaluated
logical expression (see examples).}

\item{population}{the number of individuals in the population.}

\item{conf_level}{a number representing the confidence level for which to
calculate the confidence interval. Defaults to 0.95, representing a 95\%
confidence interval using \code{\link[binom:binom.confint]{binom::binom.wilson()}}}

\item{multiplier}{The base by which to multiply the output:
\itemize{
\item \code{multiplier = 1}: ratio between 0 and 1
\item \code{multiplier = 100}: proportion
\item \code{multiplier = 10^4}: x per 10,000 people
}}

\item{mergeCI}{Whether or not to put the confidence intervals in one column (default is FALSE)}

\item{digits}{if \code{mergeCI = TRUE}, this determines how many digits are printed}

\item{x}{a data frame}

\item{group}{the bare name of a column to use for stratifying the output}

\item{add_total}{if \code{group} is not NULL, then this will add a row containing
the total value across all groups.}
}
\value{
a data frame with five columns that represent the numerator,
denominator, rate, lower bound, and upper bound.
\itemize{
\item \code{attack_rate()}: cases, population, ar, lower, upper
\item \code{case_fatality_rate()}: deaths, population, cfr, lower, upper
}
}
\description{
Calculate attack rate, case fatality rate, and mortality rate
}
