% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesdist.R
\name{mahal}
\alias{mahal}
\title{Classify using Mahalanobis distance}
\usage{
mahal(data, train)
}
\arguments{
\item{data}{A vector or matrix of data}

\item{train}{A Gaussian model generated by \code{train}.}
}
\value{
A label vector with one element per row of \code{data}
}
\description{
Classifies using Mahalanobis distance
}
\details{
The \code{model} argument contains the mean and inverse covariance matrix
(or standard deviation if the data is one-dimensional) for each class in
the training set as well as the class labels.  This function calculates the
Mahalanobis distance of each row of \code{data} from each class mean and
assigns the label of the closest mean to that row.  The result is a vector
of labels corresponding to the rows of \code{data}.

The Mahalanobis distance between a data point and a class is the Euclidean
distance between the point and the class mean divided by the covariance
matrix for the class.  This means that classes with large covariances will
attract data points from a larger area than those with small covariances.
}
\references{
O'Shaughnessy, D. Speech Communication (Addison-Wesley:
Reading, MA. 1987)
}
\seealso{
train
}
\keyword{misc}
