% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclipseplot.R
\name{eclipseplot}
\alias{eclipseplot}
\title{Create a plot for a risk of bias assessment with the ROBUST-RCT tool}
\usage{
eclipseplot(
  robust_data,
  standard = TRUE,
  optionals = FALSE,
  title = NULL,
  plot = "full",
  design = "horizontal",
  proportions = NULL
)
}
\arguments{
\item{robust_data}{A data frame containing the data from the risk-of-bias assessment with the ROBUST-RCT tool.}

\item{standard}{Logical. If \code{TRUE} (default), displays the two-step eclipseplot. If \code{TRUE} (default), displays only the step 2 (judgment).}

\item{optionals}{Logical. If \code{TRUE}, includes columns \code{opt1} to \code{opt9}.}

\item{title}{Character. Custom title for the eclipse plot.}

\item{plot}{Character. Parts to display: \code{"full"} (default), \code{"eclipses"}, or \code{"legend"}.}

\item{design}{Character. Orientation of the assembly: \code{"horizontal"} (default) or \code{"vertical"}.}

\item{proportions}{Numeric vector of length 2. Relative widths/heights for plot and legend.}
}
\value{
A \code{ggplot} object (specifically a \code{ggdraw} object from the \code{cowplot} package)
representing the visualization of the risk of bias. The output can be further customized
using standard \code{ggplot2} functions or saved via \code{save_eclipseplot}.
}
\description{
A visual representation of risk-of-bias assessments of randomized controlled trials using the ROBUST-RCT framework, as described in Wang et al. (2025) <doi:10.1136/bmj-2024-081199>.
It can display either the standard two-step assessment or a simplified judgment-only version.
}
\details{
The input data frame must include the required columns for the ROBUST-RCT domains.
The following columns are expected:
\itemize{
  \item \strong{pmid:} PubMed ID or unique identifier.
  \item \strong{study:} Study name (e.g., "Author, 2026").
  \item \strong{Core Items (1-6):} Columns named 'itemX_step1' and 'itemX_step2' (where X is 1 to 6). As standard in the ROBUST-RCT tool, item 6 does not have a multiple-choice step 1 evaluation, so it is automatically marked as NA.
  \item \strong{Optional Items:} If optionals = TRUE, columns named 'optX_step1' and 'optX_step2' (where X is 1 to 9).
}

\strong{Allowed values for Step 1 (Evaluation):} "Definitely Yes", "Probably Yes", "Probably No", "Definitely No", "Not applicable".

\strong{Allowed values for Step 2 (Judgment):} "Definitely Low", "Probably Low", "Probably High", "Definitely High", "Not applicable".
}
\section{Dataset Structure}{

Your CSV should look like this (Top 2 rows):
\preformatted{
"pmid","study","item1_step1","item1_step2","item2_step1"..."item6_step2"
"40001","Albert, 2024","Definitely Yes","Definitely Low",..."Probably Low"
}


\strong{Color Mapping:}
\itemize{
  \item Definitely Low / Definitely Yes: Blue (#4C72B0)
  \item Probably Low / Probably Yes: Light Blue (#c3d0e4)
  \item Probably High / Probably No: Light Red (#f5c7c7)
  \item Definitely High / Definitely No: Red (#E15759)
  \item Not applicable: Grey (#D3D3D3)
}
}

\examples{
# 1. Standard plot (Core items, Steps 1 & 2)
data(sample_brief)
eclipseplot_plot <- eclipseplot(sample_brief)
print(eclipseplot_plot)

\donttest{
# 2. Judgment only (Core items, Step 2)
eclipseplot(sample_long, standard = FALSE)

# 3. Plot with optional items (Core and optional items, Steps 1 & 2)
eclipseplot(sample_long, optionals = TRUE)

# 4. Judgment only with optional items (Core and optional items, Step 2)
eclipseplot(sample_long, standard = FALSE, optionals = TRUE)

# 5. Vertical full-page plot
eclipseplot(sample_long, design = "vertical", proportions = c(0.7, 0.3))

# 6. Plotting only the dots
eclipseplot(sample_brief, plot = "eclipses")

# 7. Plotting only the legend
eclipseplot(sample_brief, plot = "legend")
}

}
\author{
Pedro Rodrigues Vidor \email{pedro.vidor@ufrgs.br}

Yohan Casiraghi (Contributor)

Sofia Simoni Rossi Fermo (Contributor)

Adolfo Moraes de Souza (Contributor)

Patricia Klarmann Ziegelmann (Contributor)

Maria Inês Schmidt (Contributor)

Maicon Falavigna (Contributor)
}
