% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{is.tune_esn}
\alias{is.tune_esn}
\title{Checks if object is of class "tune_esn"}
\usage{
is.tune_esn(object)
}
\arguments{
\item{object}{object to be tested.}
}
\value{
Logical value. If \code{TRUE}, the object is of class \code{tune_esn}.
}
\description{
Returns \code{TRUE} if the object is of class \code{tune_esn}.
}
\examples{
xdata <- as.numeric(AirPassengers)
fit <- tune_esn(
  y = xdata,
  n_ahead = 12,
  n_split = 5,
  alpha = c(0.5, 1),
  rho   = c(1.0),
  tau   = c(0.4),
  inf_crit = "bic"
)
is.tune_esn(fit)

}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{plot.esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{plot.tune_esn}()},
\code{\link{print.esn}()},
\code{\link{summary.esn}()},
\code{\link{summary.tune_esn}()},
\code{\link{train_esn}()},
\code{\link{tune_esn}()}
}
\concept{base functions}
