% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{dd_LL_sr}
\alias{dd_LL_sr}
\title{Log-Likelihood for screening hmnl model}
\usage{
dd_LL_sr(draw, dd, fromdraw = 1)
}
\arguments{
\item{draw}{A list, 'echoice2' draws object}

\item{dd}{A tibble, tidy choice data (before dummy-coding)}

\item{fromdraw}{An integer, from which draw onwards to compute LL (i.e., excl. burnin)}
}
\value{
N x Draws Matrix of log-Likelihood values
}
\description{
Log-Likelihood for screening hmnl model
}
\examples{
data(icecream_discrete)
#fit model
icecream_est <- icecream_discrete \%>\% dd_est_hmnl_screen(R=10, keep=1, cores=2)
#compute likelihood for each subject in each draw
loglls<-dd_LL_sr(icecream_est, icecream_discrete, fromdraw = 2)
}
