% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_output.R
\name{load_simulation_output}
\alias{load_simulation_output}
\title{Rebuild eam_simulation_output from an existing output directory}
\usage{
load_simulation_output(output_dir)
}
\arguments{
\item{output_dir}{The directory containing the simulation results and config}
}
\value{
A eam_simulation_output object
}
\description{
This function reconstructs a eam_simulation_output object from a
previously saved simulation output directory.
}
\examples{
# Load simulation output from package data
sim_output_path <- system.file(
  "extdata", "rdm_minimal", "simulation",
  package = "eam"
)
sim_output <- load_simulation_output(sim_output_path)

# Access the configuration
sim_output$simulation_config

# Access the dataset (check arrow documentation for working with the dataset)
dataset <- sim_output$open_dataset()

}
