% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-rd.R, R/count.R
\name{count.duckplyr_df}
\alias{count.duckplyr_df}
\title{Count the observations in each group}
\usage{
\method{count}{duckplyr_df}(
  x,
  ...,
  wt = NULL,
  sort = FALSE,
  name = NULL,
  .drop = group_by_drop_default(x)
)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.}

\item{wt}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}

\item{.drop}{Handling of factor levels that don't appear in the data, passed
on to \code{\link[dplyr:group_by]{group_by()}}.

For \code{count()}: if \code{FALSE} will include counts for empty groups (i.e. for
levels of factors that don't exist in the data).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}} For \code{add_count()}: defunct since it
can't actually affect the output.}
}
\description{
This is a method for the \code{\link[dplyr:count]{dplyr::count()}} generic.
See "Fallbacks" section for differences in implementation.
\code{count()} lets you quickly count the unique values of one or more variables:
\code{df \%>\% count(a, b)} is roughly equivalent to
\code{df \%>\% group_by(a, b) \%>\% summarise(n = n())}.
\code{count()} is paired with \code{tally()}, a lower-level helper that is equivalent
to \code{df \%>\% summarise(n = n())}. Supply \code{wt} to perform weighted counts,
switching the summary from \code{n = n()} to \code{n = sum(wt)}.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{count.duckplyr_df()}
\itemize{
\item with complex expressions in \code{...},
\item with \code{.drop = FALSE},
\item with \code{sort = TRUE}.
}

These features fall back to \code{\link[dplyr:count]{dplyr::count()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
count(mtcars, am)
}
\seealso{
\code{\link[dplyr:count]{dplyr::count()}}
}
