% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute-rd.R, R/transmute.R
\name{transmute.duckplyr_df}
\alias{transmute.duckplyr_df}
\title{Create, modify, and delete columns}
\usage{
\method{transmute}{duckplyr_df}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}
}
\description{
This is a method for the \code{\link[dplyr:transmute]{dplyr::transmute()}} generic.
See "Fallbacks" section for differences in implementation.
\code{transmute()} creates a new data frame containing only the specified computations.
It's superseded because you can perform the same job with \code{mutate(.keep = "none")}.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{transmute.duckplyr_df()}
\itemize{
\item with a selection that returns no columns:
}

These features fall back to \code{\link[dplyr:transmute]{dplyr::transmute()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
transmute(mtcars, mpg2 = mpg*2)
}
\seealso{
\code{\link[dplyr:transmute]{dplyr::transmute()}}
}
