% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_last.R
\name{dtms_last}
\alias{dtms_last}
\title{Calculate the distribution of the time until a subset of states is left for
the last time.}
\usage{
dtms_last(
  probs = NULL,
  matrix = NULL,
  dtms,
  risk,
  risk_to = NULL,
  start_time = NULL,
  start_state = NULL,
  start_distr = NULL,
  end_time = NULL,
  method = "mid",
  total = TRUE,
  rescale = TRUE
)
}
\arguments{
\item{probs}{Data frame with transition probabilities, as created with \code{dtms_transitions}.}

\item{matrix}{Matrix with transition probabilities, as generated with \code{dtms_matrix}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{risk}{Character, name of state(s) for which risk is of interest.}

\item{risk_to}{Character (optional), names of one or several states to which the states specified in `risk` are left. See details.}

\item{start_time}{Numeric (optional), value of time scale for start. If NULL (default) first value of time scale will be used.}

\item{start_state}{Character (optional), name of starting states. If NULL (default) all transient states will be used.}

\item{start_distr}{Numeric (optional), distribution of starting states. If specified, average distribution over all starting states will be calculated.}

\item{end_time}{Numeric (optional), last value of time scale to consider. If NULL (default) all values of time scale starting from start_time will be used.}

\item{method}{Character (optional), do transitions happen mid-interval (`mid`, default) or at the end of the interval (`end`), see details.}

\item{total}{Logical, should total of distribution be shown (always sums to 1)? Default is FALSE.}

\item{rescale}{Logical (optional), should distribution be rescaled to sum to 1? See details. Default is TRUE.}
}
\value{
Matrix with the distribution(s) of the waiting time.
}
\description{
Calculates the distribution of the until a subset of states is left for the
very last time.
}
\details{
The resulting distribution is conditional on ever experiencing the final
exit, as the waiting time otherwise is not a finite number. The argument
`rescale` can be used to control whether the distribution is rescaled to
sum to 1; it usually will do without rescaling.

The state(s) which count to the time are specified with the argument `risk`.
If several states are specified, the resulting distribution refers to the
lifetime spent in any of the specified states. The optional argument
`risk_to` can be used to restrict results to exits from the set `risk` to
another specific subset defined by `risk_to`; i.e., this way, not all
transitions out of `risk` count for the final exit, but only those to
specific states.

In a discrete-time model, the time spent in a state depends on assumptions
about when transitions happen. Currently, this functions supports two
variants which can be specified with the argument `method`: mid-interval
transitions can be selected with the option `mid` and imply that transitions
happen at the middle of the time interval; and the option `end` assumes
that instead transitions happen at the end of the interval. In this latter
case the distribution of the time spent in a state is equivalent to the
number of visits to that state. The calculation takes the step length of
the time scale into account as specified by the `dtms` object. If the
step length is not one fixed value, the first entry of `dtms$timestep` will
be used.

If a distribution of the starting states is provided with `start_distr` the
output table has two additional rows. One shows the distribution
unconditional on the starting state. The other shows the distribution
conditional on not starting in any state of the risk set.

The distribution of partial waiting times can be generated using the arguments
`start_state` and `start_time` in combination with `end_time`.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
# Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs <- dtms_transitions(dtms=simple,
                          model = fit)
## Get starting distribution
S <- dtms_start(dtms=simple,
                data=estdata)
## First visit
dtms_last(dtms=simple,
          probs=probs,
          risk="A",
          start_distr=S)
}
\seealso{
\code{\link{dtms_distr_summary}} to help with summarizing the resulting distribution.
}
