% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_absorbed.R
\name{dtms_absorbed}
\alias{dtms_absorbed}
\title{Calculate the distribution of the time until entering an absorbing state}
\usage{
dtms_absorbed(
  probs = NULL,
  matrix = NULL,
  dtms,
  start_distr = NULL,
  start_state = NULL,
  start_time = NULL,
  end_time = NULL,
  method = "mid"
)
}
\arguments{
\item{probs}{Data frame with transition probabilities, as created with \code{dtms_transitions}.}

\item{matrix}{Matrix with transition probabilities, as generated with \code{dtms_matrix}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{start_distr}{Numeric (optional), distribution of starting states. If specified, average distribution over all starting states will be calculated.}

\item{start_state}{Character (optional), name of starting states. If NULL (default) all transient states will be used.}

\item{start_time}{Numeric (optional), value of time scale for start. If NULL (default) first value of time scale will be used.}

\item{end_time}{Numeric (optional), last value of time scale to consider. If NULL (default) all values of time scale starting from start_time will be used.}

\item{method}{Character (optional), do transitions happen mid-interval (`mid`, default) or at the end of the interval (`end`), see details.}
}
\value{
A table with the distribution of time until entering any of the absorbing states.
}
\description{
Calculates the distribution of the time until entering any of the absorbing
states.
}
\details{
In a discrete-time model, the time spent in a state depends on assumptions
about when transitions happen. Currently, this functions supports two
variants which can be specified with the argument `method`: mid-interval
transitions can be selected with the option `mid` and imply that transitions
happen at the middle of the time interval; and the option `end` assumes
that instead transitions happen at the end of the interval. The calculation
takes the step length of the time scale into account as specified by the
`dtms` object. If the #' step length is not one fixed value, the first entry
of `dtms$timestep` will be used.

If a distribution of the starting states is provided with `start_distr` the
output table has an additional row, showing the waiting time distribution
unconditional on the starting state.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
## Get starting distribution
S <- dtms_start(dtms=simple,
                data=estdata)
## Distribution of visits
dtms_absorbed(dtms=simple,
              probs=probs,
              start_distr=S)
}
