% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorted_mat.R
\name{sorted_mat}
\alias{sorted_mat}
\title{Sort Feature Matrix by Tree and Correlation Structure}
\usage{
sorted_mat(
  tree_res = NULL,
  target_lab = NULL,
  show = c("all", "train", "test"),
  trans_type = c("normalize", "scale", "percentize", "none"),
  col_proximity = c("pearson", "spearman", "kendall"),
  linkage_method = c("CT", "SG", "CP"),
  seriate_method = "TSP",
  w = 5,
  sort_by_data_type = TRUE
)
}
\arguments{
\item{tree_res}{A list returned by compute_tree(), containing fit, dat, and plot_data.}

\item{target_lab}{Character. Name of the target column to exclude from features.}

\item{show}{Character. "train","test", or "all" to select subset before sorting.}

\item{trans_type}{Character. One of "percentize","normalize","scale","none" passed to scale_norm().}

\item{col_proximity}{Character. Correlation method: "pearson","spearman","kendall".}

\item{linkage_method}{Character. Linkage for supervised distance: "CT","SG","CP".}

\item{seriate_method}{Character. Seriation method for distance objects; see
\code{seriation::list_seriation_methods("dist")} for all supported options. Default: \code{"TSP"}.}

\item{w}{Integer. Window size for RGAR calculation.}

\item{sort_by_data_type}{Logical. If TRUE, preserves data_type grouping within nodes.}
}
\value{
A list with:
\itemize{
\item sorted_row_names, sorted_col_names
\item row_pro_mat_sorted, col_pro_mat_sorted
\item cRGAR_score
\item sorted_test_matrix
\item node_ids
\item dat_sorted
}
}
\description{
Orders samples and features based on tree-derived node grouping and correlation-based seriation.
}
\examples{
\donttest{
library(rpart)
library(partykit)
library(ggparty)
library(dplyr)
library(seriation)
data <- add_data_type(
  data_all = Psychosis_Disorder
)
data <- prepare_features(
  data,
  target_lab = "UNIQID",
  task = "classification"
)
fit <- train_tree(
  data = data, target_lab = "UNIQID",
  model = "rpart"
)$fit
tree_res <- compute_tree(
  fit,
  model = "rpart", show = "all",
  data = data, target_lab = "UNIQID",
  task = "classification"
)
sorted_dat <- sorted_mat(
  tree_res,
  target_lab = "UNIQID",
  show = "all", trans_type = "none",
  seriate_method = "GW_average",
  sort_by_data_type = FALSE
)
sorted_dat$row_pro_mat_sorted
sorted_dat$col_pro_mat_sorted
sorted_dat$cRGAR_score
}
}
