% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{van_bourg_2020}
\alias{van_bourg_2020}
\title{Van Bourg et al. (2020) data}
\format{
A tibble with 201 rows and 6 variables.
}
\source{
\href{https://www.discovr.rocks/csv/van_bourg_2020.csv}{www.discovr.rocks/csv/van_bourg_2020.csv}
}
\usage{
van_bourg_2020
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Pet dogs often engage in behaviours helpful to their owners (mine likes to cuddle me when I've had a bad day, and in fact when I've had a good day, and now I think of it, pretty much any day regardless of how good or bad its been).
It's unclear whether these behaviours are truly prosocial. Can a dog engage in prosocial behaviours that haven't been explicitly trained?
Bourg et al (2020) addressed this question by trapping some dog's owners in boxes! In the study 60 dogs were tested in three conditions all of which involved being in a room with large restrainer box
(a large acrylic box with holes in the side that could be closed by resting a foam board door across its opening). Each dog had three experiences in the room and each time the experimenters were interested in whether the dog would open the restrainer box within 120 seconds.
The order of the 3 experiences was counterbalanced so different dogs completed the experiences in different orders.
\itemize{
\item The \strong{food} condition: food was dropped into the restrainer. This condition was to test whether the dog was capable of moving the foam board door to open the box (to get the food).
\item The distress condition: the dogs' owner was placed in the restrainer and was instructed to call for help in a distressed tone.
\item The reading condition: the dogs' owner was placed in the restrainer and was instructed to read from a magzine at the same pace and in the same tone as in the distress condition.
}

This data contains a subset of variables from the study, but the full dataset is available in the supplementary materials of the paper \doi{https://doi.org/10.1371/journal.pone.0231742.s001}.
The data contains the following variables
\itemize{
\item \strong{name}: The dog's name
\item \strong{dog_id}: A unique identifier for each dog
\item \strong{condition}: Which condition the dog was participating in at the time (distress, food, reading).
\item \strong{test_number}: A number form 1 to 3 indicating the order in which the particular condition was administered. For example, 2 would indicate that the data relate to the second of the three tests that the dog experienced.
\item \strong{latency}: The time taken to open the box in seconds. If the dog did not open the box a maximum of 120s was recorded.
\item \strong{opened_door}: Dis the dog open the restrainer box (1 = yes, 0 = no).
}
}
\references{
\itemize{
\item Van Bourg, J., Patterson, J. E., & Wynne, C. D. L. (2020). Pet dogs (Canis lupus familiaris) release their trapped and distressed owners: Individual variation and evidence of emotional contagion. \emph{PLOS ONE}, 15(4), e0231742. \doi{10.1371/journal.pone.0231742}
}
}
\keyword{datasets}
