% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_directadjusting.R
\docType{package}
\name{directadjusting-package}
\alias{directadjusting}
\alias{directadjusting-package}
\title{directadjusting: Directly Adjusted Estimates}
\description{
Compute estimates and confidence intervals of weighted averages quickly and easily. Weighted averages are computed using data.table for speed. Confidence intervals are approximated using the delta method with either using known formulae or via algorithmic or numerical integration.

\href{https://github.com/FinnishCancerRegistry/directadjusting/actions/workflows/R-CMD-check.yaml}{\if{html}{\figure{https://github.com/FinnishCancerRegistry/directadjusting/actions/workflows/R-CMD-check.yaml/badge.svg}}}
}
\section{Recommended installation}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{devtools::install_github(
  "FinnishCancerRegistry/directadjusting@release"
)
}\if{html}{\out{</div>}}
}

\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# suppose we have poisson rates that we want to adjust for by age group.
# they are stratified by sex.
set.seed(1337)
offsets <- rnorm(8, mean = 1000, sd = 100)
baseline <- 100
sex_hrs <- rep(1:2, each = 4)
age_group_hrs <- rep(c(0.75, 0.90, 1.10, 1.25), times = 2)
counts <- rpois(8, baseline * sex_hrs * age_group_hrs)

# raw estimates
my_stats <- data.table::data.table(
  sex = rep(1:2, each = 4),
  ag = rep(1:4, times = 2),
  e = counts / offsets
)
my_stats[, "v" := my_stats[["e"]] / offsets]
print(my_stats)
#      sex    ag          e            v
#    <int> <int>      <num>        <num>
# 1:     1     1 0.08928141 8.759527e-05
# 2:     1     2 0.10054601 1.175523e-04
# 3:     1     3 0.11987410 1.238776e-04
# 4:     1     4 0.09722692 8.365551e-05
# 5:     2     1 0.18043221 1.937844e-04
# 6:     2     2 0.14781448 1.227479e-04
# 7:     2     3 0.21747515 1.987203e-04
# 8:     2     4 0.21519746 1.781152e-04

# adjusted by age group
my_adj_stats <- directadjusting::directly_adjusted_estimates(
  stats_dt = my_stats,
  stat_col_nms = "e",
  var_col_nms = "v",
  conf_lvls = 0.95,
  conf_methods = "log",
  stratum_col_nms = "sex",
  adjust_col_nms = "ag",
  weights = c(200, 300, 400, 100)
)

print(my_adj_stats)
# Key: <sex>
#      sex         e            v       e_lo      e_hi
#    <int>     <num>        <num>      <num>     <num>
# 1:     1 0.1056924 3.474049e-05 0.09474912 0.1178996
# 2:     2 0.1889406 5.237509e-05 0.17527556 0.2036710
}\if{html}{\out{</div>}}
}

\section{News}{

\subsection{News for version 0.6.1}{
\subsection{directadjusting}{

DESCRIPTION and documentation fixes.
}

}

\subsection{News for version 0.6.0}{
\subsection{directadjusting}{

First CRAN release.
}

}

\subsection{News for version 0.5.0}{
\subsection{directadjusting::direct_adjusted_estimates}{

\code{directadjusting::delta_method_confidence_intervals} made a lot more
flexible. It now accepts via \code{conf_method} a string, a call, and a list
of calls that produce the desired confidence intervals.
}

\subsection{directadjusting::direct_adjusted_estimates}{

\code{directadjusting::direct_adjusted_estimates} option \code{conf_methods = "boot"}
removed. Only delta method confidence intervals now possible. Making use of
the delta method is now more flexible and accepts e.g.
\code{list("log", list(g = quote(qnorm(theta)), g_inv = quote(pnorm(g))))}.
}

\subsection{directadjusting::direct_adjusted_estimates}{

\code{directadjusting::direct_adjusted_estimates} now allows for the sake of
convenience to be called with no \code{adjust_col_nms} defined. This results
in no adjusting.
}

}

\subsection{News for version 0.4.0}{
\subsection{directadjusting::direct_adjusted_estimates}{

\code{directadjusting::direct_adjusted_estimates} now correctly uses
the same \code{conf_lvls} and \code{conf_methods} for all statistics when their
length is one.
}

}

\subsection{News for version 0.3.0}{
\subsection{directadjusting}{

Remove deprecated \code{directadjusting::direct_adjusted_estimates}. Use
\code{directadjusting::directly_adjusted_estimates}.
}

}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/FinnishCancerRegistry/directadjusting/}
  \item Report bugs at \url{https://github.com/FinnishCancerRegistry/directadjusting/issues}
}

}
\author{
\strong{Maintainer}: Joonas Miettinen \email{joonas.miettinen@cancer.fi} (\href{https://orcid.org/0000-0001-8624-6754}{ORCID})

}
\keyword{internal}
