% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{predict.difNLR}
\alias{predict.difNLR}
\title{Predicted values for an object of the \code{"difNLR"} class.}
\usage{
\method{predict}{difNLR}(object, item = "all", match, group, interval = "none", CI = 0.95, ...)
}
\arguments{
\item{object}{an object of the \code{"difNLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to apply for all
converged items (default), or a vector of item names (column names of the
\code{Data}), or item identifiers (integers specifying the column number).}

\item{match}{numeric: a matching criterion for new observations.}

\item{group}{numeric: a group membership variable for new observations.}

\item{interval}{character: a type of interval calculation, either
\code{"none"} (default) or \code{"confidence"} for confidence
interval.}

\item{CI}{numeric: a significance level for confidence interval (the default is
\code{0.95} for 95\% confidence interval).}

\item{...}{other generic parameters for the \code{predict()} method.}
}
\description{
S3 method for predictions from the fitted model used in the object of the
\code{"difNLR"} class.
}
\examples{
\dontrun{
# loading data
data(GMAT)
Data <- GMAT[, 1:20] # items
group <- GMAT[, "group"] # group membership variable

# testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# predicted values
summary(predict(x))
predict(x, item = 1)
predict(x, item = "Item1")

# predicted values for new observations - average score
predict(x, item = 1, match = 0, group = 0) # reference group
predict(x, item = 1, match = 0, group = 1) # focal group
predict(x, item = 1, match = 0, group = c(0, 1)) # both groups

# predicted values for new observations - various Z-scores and groups
new.match <- rep(c(-1, 0, 1), each = 2)
new.group <- rep(c(0, 1), 3)
predict(x, item = 1, match = new.match, group = new.group)

# predicted values for new observations with confidence intervals
predict(x, item = 1, match = new.match, group = new.group, interval = "confidence")
predict(x, item = c(2, 4), match = new.match, group = new.group, interval = "confidence")
}

}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of differential item
functioning with nonlinear regression: A non-IRT approach accounting for
guessing. Journal of Educational Measurement, 54(4), 498--517,
\doi{10.1111/jedm.12158}.

Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression
models for DIF and DDF detection. The R Journal, 12(1), 300--323,
\doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[difNLR]{difNLR}} for DIF detection among binary data using the generalized logistic regression model. \cr
\code{\link[stats]{predict}} for a generic function for prediction.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
