% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_functions.R
\name{remove.close}
\alias{remove.close}
\title{A Helper Function to Tell Which Points Are Near the Boundary of a Circle}
\usage{
remove.close(ps, x, y, r)
}
\arguments{
\item{ps}{an n x 2 matrix of potential points.}

\item{x}{the x coordinate of the center of the circle.}

\item{y}{the y coordinate of the center of the circle.}

\item{r}{the radius of the circle}
}
\value{
\item{inds}{tells which points are too close to the edge of the
circle. }
}
\description{
Used in venn3 to tell which of the potential points to be plotted are near
the boundary of the circle defned by x, y, and r.
}
\examples{



ps <- cbind(runif(100), runif(100))
inds <- dga:::remove.close(ps, .5, .5, .1)
}
\author{
Kristian Lum \email{kl@hrdag.org}
}
\keyword{circle}
