% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgload.R
\name{load_all}
\alias{load_all}
\title{Load complete package}
\usage{
load_all(
  path = ".",
  reset = TRUE,
  recompile = FALSE,
  export_all = TRUE,
  helpers = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{path}{Path to a package, or within a package.}

\item{reset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This is no longer supported
because preserving the namespace requires unlocking its environment, which
is no longer possible in recent versions of R.}

\item{recompile}{DEPRECATED. force a recompile of DLL from source code, if
present. This is equivalent to running \code{\link[pkgbuild:clean_dll]{pkgbuild::clean_dll()}} before
\code{load_all()}}

\item{export_all}{If \code{TRUE} (the default), export all objects.
If \code{FALSE}, export only the objects that are listed as exports
in the NAMESPACE file.}

\item{helpers}{if \code{TRUE} loads \pkg{testthat} test helpers.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{...}{Additional arguments passed to \code{\link[pkgload:load_all]{pkgload::load_all()}}.}
}
\description{
\code{load_all()} loads a package. It roughly simulates what happens
when a package is installed and loaded with \code{\link[=library]{library()}}, without
having to first install the package. It:
\itemize{
\item Loads all data files in \verb{data/}. See \code{\link[pkgload:load_data]{load_data()}} for more
details.
\item Sources all R files in the R directory, storing results in
environment that behaves like a regular package namespace. See
\code{\link[pkgload:load_code]{load_code()}} for more details.
\item Adds a shim from \code{\link[pkgload:system.file]{system.file()}} to \code{\link[pkgload:shim_system.file]{shim_system.file()}} in
the imports environment of the package. This ensures that \code{system.file()}
works with both development and installed packages despite their differing
directory structures.
\item Adds shims from \code{help()} and \verb{?} to \code{\link[pkgload:shim_help]{shim_help()}} and \code{\link[pkgload:shim_question]{shim_question()}}
to make it easier to preview development documentation.
\item Compiles any C, C++, or Fortran code in the \verb{src/} directory and
connects the generated DLL into R. See \code{\link[pkgbuild:compile_dll]{pkgbuild::compile_dll()}}
for more details.
\item Loads any compiled translations in \code{inst/po}.
\item Runs \code{.onAttach()}, \code{.onLoad()} and \code{.onUnload()} functions at
the correct times.
\item If you use \pkg{testthat}, will load all test helpers so you can
access them interactively. devtools sets the \code{DEVTOOLS_LOAD}
environment variable to the package name to let you check whether the
helpers are run during package loading.
}

\code{is_loading()} returns \code{TRUE} when it is called while \code{load_all()}
is running. This may be useful e.g. in \code{.onLoad} hooks.
A package loaded with \code{load_all()} can be identified with
\code{\link[pkgload:is_dev_package]{is_dev_package()}}.
}
\section{Differences to regular loading}{

\code{load_all()} tries its best to reproduce the behaviour of
\code{\link[=loadNamespace]{loadNamespace()}} and \code{\link[=library]{library()}}. However it deviates from normal
package loading in several ways.
\itemize{
\item \code{load_all()} doesn't install the package to a library, so \code{\link[pkgload:system.file]{system.file()}}
doesn't work. pkgload fixes this for the package itself installing a shim,
\code{\link[pkgload:shim_system.file]{shim_system.file()}}. However, this shim is not visible to third party
packages, so they will fail if they attempt to find files within your
package. One potential workaround is to use \code{\link[fs:path_package]{fs::path_package()}}
instead of \code{system.file()}, since that understands the mechanisms that
devtools uses to load packages.
\item \code{load_all()} loads all packages referenced in \code{Imports} at load time,
but \code{loadNamespace()} and \code{library()} only load package dependencies as
they are needed.
\item \code{load_all()} copies all objects (not just the ones listed as exports)
into the package environment. This is useful during development because
it makes internal objects easy to access.  To export only the objects
listed as exports, use \code{export_all = FALSE}. This more closely simulates
behavior when loading an installed package with \code{\link[=library]{library()}}, and can
be useful for checking for missing exports.
}

}

\section{Controlling the debug compiler flags}{

\code{load_all()} delegates to \code{\link[pkgbuild:compile_dll]{pkgbuild::compile_dll()}} to perform the actual
compilation, during which by default some debug compiler flags are
appended. If you would like to produce an optimized build instead, you can
opt out by either using \code{debug = FALSE}, setting the \code{pkg.build_extra_flags}
option to \code{FALSE}, or setting the \code{PKG_BUILD_EXTRA_FLAGS} environment variable
to \code{FALSE}. For further details see the Details section in \code{\link[pkgbuild:compile_dll]{pkgbuild::compile_dll()}}.

}

\examples{
\dontrun{
# Load the package in the current directory
load_all("./")

# Running again loads changed files
load_all("./")

# With export_all=FALSE, only objects listed as exports in NAMESPACE
# are exported
load_all("./", export_all = FALSE)
}
}
