% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImpact.R
\name{GetFeatureImpact}
\alias{GetFeatureImpact}
\title{Get the feature impact for a model, requesting the feature impact if it is not already
available.}
\usage{
GetFeatureImpact(model)
}
\arguments{
\item{model}{character. The model for which you want to compute Feature Impact, e.g.
from the list of models returned by \code{ListModels(project)}.}
}
\description{
Feature Impact is computed for each column by creating new data with that column randomly
permuted (but the others left unchanged), and seeing how the error metric score for the
predictions is affected. The 'impactUnnormalized' is how much worse the error metric score is
when making predictions on this modified data. The 'impactNormalized' is normalized so that the
largest value is 1. In both cases, larger values indicate more important features. Elsewhere this
technique is sometimes called 'Permutation Importance'.
}
\details{
Note that \code{GetFeatureImpact} will block for the duration of feature impact calculation. If
you would prefer not to block the call, use \code{RequestFeatureImpact} to generate an async
request for feature impact and then use \code{GetFeatureImpactForModel} or
\code{GetFeatureImpactForJobId} to get the feature impact when it has been calculated.
\code{GetFeatureImpactForJobId} will also block until the request is complete, whereas
\code{GetFeatureImpactForModel} will error if the job is not complete yet.
}
