% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-education.r
\docType{data}
\name{education}
\alias{education}
\title{Stock and Watson CPS Education Earnings}
\format{
A data frame containing 2,950 observations on 4 variables.

\describe{
\item{age}{Age in years.}
\item{gender}{Factor indicating gender.}
\item{earnings}{Average hourly earnings (sum of annual pretax
wages, salaries, tips, and bonuses, divided by the number of hours
worked annually).}
\item{education}{Number of years of education.}
}
}
\source{
Data corresponds to dataset \code{CPSSWEducation} from the package \code{AER}. Online
complements to Stock and Watson (2007).
}
\usage{
data(education)
}
\description{
Stock and Watson (2007)  provide several subsets created from March
Current Population Surveys (CPS) with data on the relationship of
earnings and education over several years. This data corresponds to
the \code{CPSSWEducation} dataset.
}
\examples{
data(education)

## Stock and Watson, p. 165
plot(earnings ~ education, data = education)
fm <- lm(earnings ~ education, data = education)
abline(fm)
}
\references{
\itemize{
\item Stock, J.H. and Watson, M.W. (2007). \emph{Introduction to
Econometrics}, 2nd ed. Boston: Addison Wesley.
}
}
\keyword{datasets}
