% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_format_conversions.R
\name{int_detect_format}
\alias{int_detect_format}
\title{Detect Interval Data Format}
\usage{
int_detect_format(x)
}
\arguments{
\item{x}{interval data in unknown format}
}
\value{
A character string indicating the detected format: "RSDA", "MM", "iGAP", "SODAS", or "unknown"
}
\description{
Automatically detect the format of interval data.
}
\details{
Detection rules:
\itemize{
  \item \code{RSDA}: has class "symbolic_tbl" and contains complex columns
  \item \code{MM}: data.frame with paired "_min" and "_max" columns
  \item \code{iGAP}: data.frame with columns containing comma-separated values (e.g., "1.2,3.4")
  \item \code{SODAS}: character string ending with ".xml" (file path)
  \item \code{SDS}: alias for SODAS
}
}
\examples{
data(mushroom.int)
int_detect_format(mushroom.int)  # Should return "RSDA"

data(abalone.iGAP)
int_detect_format(abalone.iGAP)  # Should return "iGAP"
}
