% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bats.int}
\alias{bats.int}
\title{Bat Species Interval Dataset}
\format{
A data frame with 21 observations and 4 interval-valued variables:
\itemize{
    \item \code{head}: Head length range (mm).
    \item \code{tail}: Tail length range (mm).
    \item \code{height}: Ear height range (cm).
    \item \code{forearm}: Forearm length range (mm).
}
}
\usage{
data(bats.int)
}
\description{
Interval-valued data for 21 bat species described by 4 morphological
measurements. Benchmark dataset for matrix visualization.
}
\details{
Used to demonstrate color coding schemes, the HCT-R2E seriation
algorithm, and distance measure comparisons (Gowda-Diday, Hausdorff,
City-Block, L1, L2, etc.) for interval data.
}
\examples{
data(bats.int)
}
\references{
Kao, C.-H. et al. (2014). Exploratory data analysis of interval-valued
symbolic data with matrix visualization. \emph{CSDA}, 79, 14-29.
}
\keyword{clustering}
\keyword{datasets}
\keyword{interval}
\keyword{visualization}
