% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_series.R
\name{plot_series}
\alias{plot_series}
\title{Plot series}
\usage{
plot_series(data, label_x = "", label_y = "", colors = NULL)
}
\arguments{
\item{data}{data.frame with x in the first column and series in remaining columns}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional vector of colors for series}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Line plot for one or more series over a common x index.
}
\details{
Expects a data.frame where the first column is the x index and remaining columns are numeric series.
Points and lines are drawn per series; supply \code{colors} to override the palette.
}
\examples{
x <- seq(0, 10, 0.25)
data <- data.frame(x, sin=sin(x))
head(data)

grf <- plot_series(data, colors=c("red"))
plot(grf)
}
