% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_pixel.R
\name{plot_pixel}
\alias{plot_pixel}
\title{Plot pixel visualization}
\usage{
plot_pixel(
  data,
  colors = NULL,
  title = NULL,
  label_x = "sample",
  label_y = "Attributes"
)
}
\arguments{
\item{data}{numeric matrix or data.frame}

\item{colors}{optional vector of colors for the fill gradient}

\item{title}{optional plot title}

\item{label_x}{x-axis label}

\item{label_y}{y-axis label}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Pixel-oriented visualization of a numeric matrix or data.frame.
}
\details{
Renders a heatmap-like plot where each cell is a pixel. Useful for multivariate inspection.
}
\examples{
data(iris)
grf <- plot_pixel(as.matrix(iris[,1:4]), title = "Iris")
plot(grf)
}
