% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_hist.R
\name{plot_hist}
\alias{plot_hist}
\title{Plot histogram}
\usage{
plot_hist(data, label_x = "", label_y = "", color = "white", alpha = 0.25)
}
\arguments{
\item{data}{data.frame with one numeric column (first column is used if multiple)}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{color}{fill color}

\item{alpha}{transparency level (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Histogram for a numeric column using ggplot2.
}
\details{
If multiple columns are provided, only the first is used. Breaks are computed via \code{graphics::hist} to
mirror base R binning. \code{color} controls the fill; \code{alpha} the transparency.
}
\examples{
grf <- plot_hist(iris |> dplyr::select(Sepal.Width), color=c("blue"))
plot(grf)
}
