% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_density_class.R
\name{plot_density_class}
\alias{plot_density_class}
\title{Plot density per class}
\usage{
plot_density_class(
  data,
  class_label,
  label_x = "",
  label_y = "",
  colors = NULL,
  bin = NULL,
  alpha = 0.5
)
}
\arguments{
\item{data}{data.frame with class label and a numeric column}

\item{class_label}{name of the grouping (class) column}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional vector of fills per class}

\item{bin}{optional bin width passed to \code{geom_density}}

\item{alpha}{fill transparency (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Kernel density plot grouped by a class label.
}
\details{
Expects \code{data} with a grouping column named in \code{class_label} and one numeric column. Each group is
filled with a distinct color (if provided).
}
\examples{
grf <- plot_density_class(iris |> dplyr::select(Sepal.Width, Species),
class = "Species", colors=c("red", "green", "blue"))
plot(grf)
}
