% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_louvain.R
\name{cluster_louvain_graph}
\alias{cluster_louvain_graph}
\title{Louvain community detection}
\usage{
cluster_louvain_graph(weights = NULL)
}
\arguments{
\item{weights}{optional edge weights to pass to \code{cluster_louvain}}
}
\value{
returns a Louvain clustering object.
}
\description{
Graph community detection using \code{igraph::cluster_louvain}.
}
\details{
Accepts an \code{igraph} object and returns community memberships.
Requires the \code{igraph} package.
}
\examples{
if (requireNamespace("igraph", quietly = TRUE)) {
 g <- igraph::sample_gnp(n = 20, p = 0.15)
 model <- cluster_louvain_graph()
 model <- fit(model, g)
 clu <- cluster(model, g)
 table(clu)
}
}
\references{
Blondel, V. D., Guillaume, J.-L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks. \emph{J. Statistical Mechanics}.
}
