% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{check_cycles}
\alias{check_cycles}
\title{Internal: check for cycles in the nuisance graph}
\usage{
check_cycles(nfs)
}
\arguments{
\item{nfs}{A named list of normalized nuisance specifications. Each
element must contain components \code{fit_deps} and
\code{pred_deps}, as constructed by \code{validate_method()}.}
}
\value{
Invisibly returns \code{TRUE} on success, or throws an error
if a cycle is found.
}
\description{
Validates that the combined dependency graph over all nuisances is
acyclic. The graph edges are obtained from the union of
\code{fit_deps} and \code{pred_deps} for each nuisance (including the
synthetic \code{"__TARGET__"} node).
}
\details{
If a cycle is detected, an error is thrown with a textual
representation of the cycle. Otherwise the function returns
\code{TRUE} invisibly.
}
\keyword{internal}
