% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crops.class.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset,crops.class-method}
\title{Subset crops results based on penalty values}
\usage{
\S4method{subset}{crops.class}(x, beta_min = 0, beta_max = Inf)
}
\arguments{
\item{x}{An instance of an S4 class produced by \code{\link{crops}}.}

\item{beta_min}{A positive numeric value specifying the minimum penalty value for entries in the crops result. Default value is 0.}

\item{beta_max}{A positive numeric value specifying the maximum penalty value for entries in the crops result. Default value is Inf.}
}
\value{
An instance of the S4 class type \code{crops.class}. This is the same type as produced by the \code{\link{crops}} function.
}
\description{
Removes entries from a crops result that fall outside a specified range of penalty values. 
The \code{subset} function can be useful for simplifying plots and the details produced by \code{segmentations}.
}
