% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticNormal-class}
\alias{LogisticNormal-class}
\alias{.LogisticNormal}
\alias{LogisticNormal}
\alias{.DefaultLogisticNormal}
\title{\code{LogisticNormal}}
\usage{
LogisticNormal(mean, cov, ref_dose = 1)

.DefaultLogisticNormal()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*} (strictly positive
number).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticNormal}} is the class for the usual logistic regression model with
a bivariate normal prior on the intercept and slope.
}
\details{
The covariate is the natural logarithm of the dose \eqn{x} divided by
the reference dose \eqn{x*}, i.e.:
\deqn{logit[p(x)] = alpha0 + alpha1 * log(x/x*),}
where \eqn{p(x)} is the probability of observing a DLT for a given dose \eqn{x}.
The prior \deqn{(alpha0, alpha1) ~ Normal(mean, cov).}
}
\note{
Typically, end users will not use the \code{.DefaultLogisticNormal()} function.
}
\examples{
# Define the dose-grid.
empty_data <- Data(doseGrid = c(1, 3, 5, 10, 15, 20, 25, 40, 50, 80, 100))

my_model <- LogisticNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2)
)

my_options <- McmcOptions(burnin = 10, step = 2, samples = 100)

samples <- mcmc(empty_data, my_model, my_options)
samples
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticLogNormal}}, \code{\link{LogisticLogNormalSub}},
\code{\link{ProbitLogNormal}}, \code{\link{ProbitLogNormalRel}}, \code{\link{LogisticNormalMixture}}.
}
