% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_tests.R
\name{test_permutation_robustness}
\alias{test_permutation_robustness}
\title{Permutation-based robustness test}
\usage{
test_permutation_robustness(
  factors_data,
  data_prep,
  n_perms = 100,
  seed = 123,
  use_stan = TRUE,
  chains = 4,
  iter = 2000,
  verbose = TRUE
)
}
\arguments{
\item{factors_data}{Data frame with factor information}

\item{data_prep}{Prepared data object}

\item{n_perms}{Number of permutations (default: 100)}

\item{seed}{Random seed for reproducibility (default: 123)}

\item{use_stan}{Logical, use Stan for estimation (default: TRUE)}

\item{chains}{Number of MCMC chains (default: 4)}

\item{iter}{Number of MCMC iterations (default: 2000)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{observed_lambda}}{Original mean-reversion speeds.}
\item{\code{null_distribution}}{Matrix of permutation-based lambda values.}
\item{\code{p_values}}{One-sided p-values for each factor.}
\item{\code{significant}}{Logical vector indicating significance at alpha = 0.05.}
\item{\code{effect_size}}{Standardized effect sizes (z-scores).}
}
}
\description{
Tests the robustness of factor-OU convergence findings by randomly permuting
the Y factor space and re-estimating the model. Generates empirical null
distribution for convergence statistics.
}
\details{
(too slow for many iterations).
}
