% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_estimation.R
\name{choose_var_lag}
\alias{choose_var_lag}
\title{Select optimal VAR lag order with multiple criteria}
\usage{
choose_var_lag(
  F_combined,
  lag.max = 4,
  type = "const",
  p_pref = c("SC(n)", "HQ(n)"),
  alpha = 0.05,
  oos_eval = TRUE,
  oos_start = 0.7,
  verbose = TRUE
)
}
\arguments{
\item{F_combined}{Numeric matrix (T x K) of factor scores to be modeled.}

\item{lag.max}{Integer. Maximum lag order to consider. Default is 4.}

\item{type}{Character string. Type of deterministic terms: "const" (default),
"trend", "both", or "none".}

\item{p_pref}{Character vector. Preferred information criteria for initial
selection. Default is \code{c("SC(n)", "HQ(n)")}.}

\item{alpha}{Numeric. Significance level for serial correlation test. Default is 0.05.}

\item{oos_eval}{Logical. Should out-of-sample evaluation be performed? Default is TRUE.}

\item{oos_start}{Numeric. Proportion of sample to use for training in OOS validation.
Default is 0.7.}

\item{verbose}{Logical; print progress information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{p}}{Selected optimal lag order.}
\item{\code{fit}}{Fitted VAR model object of class \code{varest}.}
\item{\code{roots_ok}}{Logical indicating if stability condition is satisfied.}
\item{\code{serial_ok}}{Logical indicating if serial correlation test passed.}
\item{\code{oos_mse}}{Out-of-sample mean squared error (if \code{oos_eval = TRUE}).}
}
}
\description{
Determines the optimal lag order for a Vector Autoregression model using
information criteria, stability checks, serial correlation tests, and optional
out-of-sample validation.
}
\details{
The function combines multiple selection criteria: (1) information
criteria (AIC, BIC, HQ), (2) VAR stability (eigenvalue modulus < 1), (3)
Portmanteau test for serial correlation, and (4) out-of-sample forecast
performance. Returns the model that best balances these considerations.
}
