% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getCurrentData}
\alias{getCurrentData}
\title{Get Current Data}
\usage{
getCurrentData(datlist, looktime, n, as.followup = TRUE)
}
\arguments{
\item{datlist}{The entire data list generated at the start of the simulation.}

\item{looktime}{The time of the current analysis point.}

\item{n}{The number of subjects corresponding to this analysis point (\code{n.at.look}).}

\item{as.followup}{If TRUE, the true looktime is when all \emph{n} patient reach follow-up. If FALSE, looktime remains
the time when the \emph{n}th patient is \emph{enrolled}. Default is \code{TRUE}.}
}
\value{
Returns a subset of the data to use in interim analysis.

\itemize{
\item{subjid: Subject ID from 1 to maximum sample size}
\item{arm: Treatment arm allocation for each subject}
\item{dat: Response for each subject (0 or 1)}
\item{arrival.day: Arrival time (days) for each subject throughout trial duration}
}
}
\description{
Get the data available at the time of the current analysis.
}
\examples{
# using included data set
data(datlist)
# This example uses the default parlist parameters
looks <- seq(500,1000,100)

# get the data available at the first interim analysis
n.at.look <- looks[1]
looktime.interim <- datlist$arrival.day[n.at.look]
currdatlist.interim <- getCurrentData(datlist, looktime.interim, n.at.look, as.followup=TRUE)
# currdatlist.interim will have a new field `KNOWN`
#3 which indicates if a patients response is known (TRUE) or not (FALSE)
}
