% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prettyHead}
\alias{prettyHead}
\title{Pretty Display of a Matrix or Data Frame}
\usage{
prettyHead(x, n = 10, width = getOption("width"), zapsmall = FALSE)
}
\arguments{
\item{x}{an R object for which \code{\link{head}} and
\code{\link{as.data.frame}} methods exist.}

\item{n}{numeric; the number of rows to display}

\item{width}{numeric; the display width to assume when formatting the data
frame. The default is given by \code{getOption("width")}}

\item{zapsmall}{logical; should values close to zero be zapped to zero? See
\code{\link{zapsmall}} for details.}
}
\value{
A \code{\link{format}}ed data frame with \code{n} rows (or
  \code{n+1} rows if only a subset is shown) and as many columns/components
  that can be printed on a single screen width.
}
\description{
Pretty display of the first \code{n} rows of a data frame or
  matrix-like object, with variables/columns that cannot fit on a single
  screen width removed.
}
\examples{

x <- seq(from = 4, to = 6, length = 30)
opt <- seq(4, 7, length = 100)
tol <- rep(0.25, 100)
h <- rep(20, 100)

## simulate
set.seed(1)
y <- coenocline(x, responseModel = "gaussian",
                params = cbind(opt = opt, tol = tol, h = h),
                countModel = "poisson")

prettyHead(y)

}
\author{
Gavin L. Simpson
}
\keyword{internal}
