\name{uiss_rcc_staging}
\alias{uiss_rcc_staging}
\title{
UCLA Integrated Staging System (UISS) for Renal Cell Carcinoma
}
\description{
Calculates the UISS risk stratification for patients with Renal Cell Carcinoma (RCC). The system divides patients into Localized or Metastatic disease categories and then stratifies them into Low, Intermediate, or High risk groups based on TNM stage, Fuhrman nuclear grade, and ECOG performance status to predict 5-year survival.
}
\usage{
uiss_rcc_staging(tnm_t_stage, tnm_n_stage, tnm_m_stage, fuhrman_grade,
                 ecog_performance_status)
}
\arguments{
  \item{tnm_t_stage}{
String. The TNM T-stage of the tumor (1997 classification). Options: "t1", "t2", "t3", "t4".
}
  \item{tnm_n_stage}{
String. The TNM N-stage. Options: "n0" (No lymph nodes), "n1", "n2" (Positive lymph nodes).
}
  \item{tnm_m_stage}{
String. The TNM M-stage. Options: "m0" (No distant metastasis), "m1" (Distant metastasis).
}
  \item{fuhrman_grade}{
Numeric. Fuhrman nuclear grade (1, 2, 3, or 4).
}
  \item{ecog_performance_status}{
Numeric. ECOG Performance Status score (0-4).
}
}
\value{
A list containing:
\item{UISS_Risk_Group}{The calculated risk group (Low, Intermediate, or High) appended with the disease state (Localized vs Metastatic).}
\item{Est_5_Year_Survival}{Estimated 5-year cancer-specific survival based on the risk group.}
}
\references{
Zisman A, Pantuck AJ, Wieder J, et al. Risk group assessment and clinical outcome algorithm to predict the natural history of patients with surgically resected renal cell carcinoma. J Clin Oncol. 2002;20(23):4559-4566. doi:10.1200/JCO.2002.05.111
}
\examples{
uiss_rcc_staging("t1", "n0", "m0", 1, 0)

uiss_rcc_staging("t3", "n1", "m0", 3, 1)
}
