\name{tokyo_guidelines_cholangitis_2018}
\alias{tokyo_guidelines_cholangitis_2018}
\title{
Tokyo Guidelines 2018 (TG18) for Acute Cholangitis
}
\description{
Diagnoses and grades the severity of acute cholangitis based on the 2018 Tokyo Guidelines. Diagnosis requires evidence of systemic inflammation, cholestasis, and imaging findings. Severity is graded from I (Mild) to III (Severe) based on organ dysfunction and other risk factors.
}
\usage{
tokyo_guidelines_cholangitis_2018(age, temperature_c, wbc_count, crp_elevated,
                                  bilirubin_mg_dl, abnormal_liver_enzymes,
                                  imaging_biliary_dilation, imaging_etiology,
                                  albumin_g_dl, hypotension_on_meds,
                                  altered_consciousness, pao2_fio2_lt_300,
                                  creatinine_mg_dl, inr, platelet_count_x10_9_l)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 75 contributes to Grade II).
}
  \item{temperature_c}{
Numeric. Body temperature in Celsius. (>38 contributes to diagnosis, >=39 contributes to Grade II).
}
  \item{wbc_count}{
Numeric. White Blood Cell count (x10^3/uL). (<4 or >10 contributes to diagnosis; <4 or >12 contributes to Grade II).
}
  \item{crp_elevated}{
Numeric (0 or 1). Is C-Reactive Protein (CRP) >= 1 mg/dL? (1 = Yes).
}
  \item{bilirubin_mg_dl}{
Numeric. Total Bilirubin in mg/dL. (>= 2 contributes to diagnosis; >= 5 contributes to Grade II).
}
  \item{abnormal_liver_enzymes}{
Numeric (0 or 1). Are ALP, GGT, AST, or ALT > 1.5x the upper limit of normal? (1 = Yes).
}
  \item{imaging_biliary_dilation}{
Numeric (0 or 1). Is there biliary dilation on imaging? (1 = Yes).
}
  \item{imaging_etiology}{
Numeric (0 or 1). Is there imaging evidence of etiology (e.g., stricture, stone, stent)? (1 = Yes).
}
  \item{albumin_g_dl}{
Numeric. Serum Albumin in g/dL. (< 0.7 x Lower Limit of Normal contributes to Grade II; standardized to approx < 2.45 g/dL).
}
  \item{hypotension_on_meds}{
Numeric (0 or 1). Hypotension requiring vasopressors? (1 = Yes, Grade III).
}
  \item{altered_consciousness}{
Numeric (0 or 1). Disturbance of consciousness? (1 = Yes, Grade III).
}
  \item{pao2_fio2_lt_300}{
Numeric (0 or 1). Is PaO2/FiO2 ratio < 300? (1 = Yes, Grade III).
}
  \item{creatinine_mg_dl}{
Numeric. Serum Creatinine in mg/dL. (> 2.0 contributes to Grade III).
}
  \item{inr}{
Numeric. INR. (> 1.5 contributes to Grade III).
}
  \item{platelet_count_x10_9_l}{
Numeric. Platelet count (x10^3/uL). (< 100 contributes to Grade III).
}
}
\value{
A list containing:
\item{Diagnosis}{Diagnostic status (No, Suspected, or Definite Acute Cholangitis).}
\item{Severity_Grade}{Severity Classification (Grade I, II, or III) if diagnosed.}
\item{Criteria_Status}{List of booleans indicating which diagnostic criteria (A, B, C) were met.}
}
\references{
Kiriyama S, Kozaka K, Takada T, et al. Tokyo Guidelines 2018: diagnostic criteria and severity grading of acute cholangitis (with videos). J Hepatobiliary Pancreat Sci. 2018;25(1):17-30. doi:10.1002/jhbp.512
}
\examples{

# Example 1: Definite Acute Cholangitis, Grade III (Severe)
# Fever, High WBC, High Bili, Dilation, Hypotension
tokyo_guidelines_cholangitis_2018(65, 39.5, 15, 1, 3.0, 1, 1, 1, 3.0, 1, 0, 0, 1.0, 1.0, 150)

# Example 2: Suspected Acute Cholangitis, Grade I (Mild)
# Fever, Abnormal LFTs, No Imaging Findings, Stable Vitals/Labs
tokyo_guidelines_cholangitis_2018(50, 38.5, 9, 0, 1.5, 1, 0, 0, 4.0, 0, 0, 0, 0.8, 1.0, 200)
}
