\name{swede_colposcopic_score}
\alias{swede_colposcopic_score}
\title{
Swede Score for Colposcopy
}
\description{
Calculates the Swede Score to grade the severity of cervical lesions during colposcopy. The score sums five colposcopic variables (Acetowhitening, Margins, Vessel patterns, Lesion size, and Iodine staining), each scored from 0 to 2. Higher scores correlate with higher-grade cervical intraepithelial neoplasia (CIN).
}
\usage{
swede_colposcopic_score(acetowhitening, margins, vessels, lesion_size,
                        iodine_staining)
}
\arguments{
  \item{acetowhitening}{
Numeric (0-2). Reaction to acetic acid.
0: Zero or transparent.
1: Faint or translucent.
2: Distinct, opaque white.
}
  \item{margins}{
Numeric (0-2). Margin/Surface characteristics.
0: Diffuse or irregular edges.
1: Sharp but irregular edges.
2: Sharp/rolled edges or internal borders ("cuffing").
}
  \item{vessels}{
Numeric (0-2). Vessel patterns.
0: Fine, regular.
1: Absent.
2: Coarse or atypical.
}
  \item{lesion_size}{
Numeric (0-2). Size of the lesion.
0: < 5 mm.
1: 5 - 15 mm or 2 quadrants.
2: > 15 mm or 3-4 quadrants or endocervical undefined.
}
  \item{iodine_staining}{
Numeric (0-2). Reaction to Lugol's iodine.
0: Brown (Positive uptake).
1: Faintly yellow or speckled.
2: Distinct mustard yellow (Negative uptake).
}
}
\value{
A list containing:
\item{Swede_Score}{The calculated total score (Range 0-10).}
\item{Interpretation}{Diagnostic likelihood (Normal/CIN1, CIN2/3, CIN3/Cancer).}
}
\references{
Strander B, Ellström-Andersson A, Franzén S, Milsom I, Rådberg T. The performance of a new scoring system for colposcopy in detecting high-grade dysplasia in the uterine cervix. Acta Obstet Gynecol Scand. 2005;84(10):1013-1017. doi:10.1111/j.0001-6349.2005.00895.x
}
\examples{

# Example 1: Low Grade
# Faint white (1), Diffuse margin (0), Fine vessels (0), Small (0), Partial iodine (1)
# Score = 2
swede_colposcopic_score(1, 0, 0, 0, 1)

# Example 2: High Grade
# Dense white (2), Sharp margins (1), Coarse vessels (2), Large (2), Yellow iodine (2)
# Score = 9
swede_colposcopic_score(2, 1, 2, 2, 2)
}
