\name{stop_bang_score}
\alias{stop_bang_score}
\title{
STOP-Bang Score for Obstructive Sleep Apnea
}
\description{
Calculates the STOP-Bang score to screen for Obstructive Sleep Apnea (OSA). The score is based on Snoring, Tiredness, Observed apnea, Blood Pressure, BMI, Age, Neck circumference, and Gender. A score of 3 or more indicates a high risk of OSA.
}
\usage{
stop_bang_score(snoring, tired, observed_apnea, pressure, bmi, age,
                neck_circumference, gender)
}
\arguments{
  \item{snoring}{
Numeric (0 or 1). Do you snore loudly? (1 = Yes).
}
  \item{tired}{
Numeric (0 or 1). Do you often feel tired, fatigued, or sleepy during daytime? (1 = Yes).
}
  \item{observed_apnea}{
Numeric (0 or 1). Has anyone observed you stop breathing during your sleep? (1 = Yes).
}
  \item{pressure}{
Numeric (0 or 1). Do you have or are you being treated for high blood pressure? (1 = Yes).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2). (> 35 kg/m^2 adds 1 point).
}
  \item{age}{
Numeric. Age in years. (> 50 years adds 1 point).
}
  \item{neck_circumference}{
Numeric. Neck circumference in cm. (> 40 cm adds 1 point).
}
  \item{gender}{
String. Gender ("Male" or "Female"). (Male adds 1 point).
}
}
\value{
A list containing:
\item{STOP_Bang_Score}{The calculated total score (Range 0-8).}
\item{Risk_Category}{Classification (Low 0-2, Intermediate 3-4, High 5-8).}
}
\references{
Chung F, Yegneswaran B, Liao P, et al. STOP-Bang questionnaire: a practical approach to screen for obstructive sleep apnea. Chest. 2008;133(3):592-598. doi:10.1378/chest.07-2587
}
\examples{

# Example 1: High Risk
# Snoring, Tired, Observed, BP, BMI 36, Age 55, Neck 42, Male
# Score = 1+1+1+1+1+1+1+1 = 8
stop_bang_score(1, 1, 1, 1, 36, 55, 42, "male")

# Example 2: Low Risk
# No symptoms, BMI 22, Age 30, Neck 35, Female
# Score = 0
stop_bang_score(0, 0, 0, 0, 22, 30, 35, "female")
}
