\name{sofa_score}
\alias{sofa_score}
\title{
Sequential Organ Failure Assessment (SOFA) Score
}
\description{
Calculates the SOFA score to track a patient's status during their stay in an intensive care unit (ICU). The score determines the extent of a person's organ function or rate of failure. It is based on six different scores, one each for the respiratory, cardiovascular, hepatic, coagulation, renal, and neurological systems.
}
\usage{
sofa_score(pao2, fio2, mechanical_ventilation, platelets, bilirubin,
           mean_arterial_pressure, vasopressor_level, gcs, creatinine)
}
\arguments{
  \item{pao2}{
Numeric. Partial pressure of oxygen in arterial blood (mmHg).
}
  \item{fio2}{
Numeric. Fraction of inspired oxygen (0.21 - 1.0 or 21 - 100).
}
  \item{mechanical_ventilation}{
Numeric (0 or 1). Is the patient on mechanical ventilation? (1 = Yes).
}
  \item{platelets}{
Numeric. Platelet count in x10^3/uL.
}
  \item{bilirubin}{
Numeric. Total bilirubin in mg/dL.
}
  \item{mean_arterial_pressure}{
Numeric. Mean Arterial Pressure in mmHg.
}
  \item{vasopressor_level}{
String. Level of vasopressor support.
"none": No vasopressors.
"low": Dopamine <= 5 or Dobutamine (any dose).
"medium": Dopamine > 5, Epinephrine <= 0.1, or Norepinephrine <= 0.1.
"high": Dopamine > 15, Epinephrine > 0.1, or Norepinephrine > 0.1.
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{creatinine}{
Numeric. Serum creatinine in mg/dL.
}
}
\value{
A list containing:
\item{SOFA_Score}{The total calculated SOFA score (Range 0-24).}
\item{Mortality_Estimate}{Approximate in-hospital mortality risk based on initial score.}
\item{Organ_Scores}{A breakdown of scores for each organ system.}
}
\references{
Vincent JL, Moreno R, Takala J, et al. The SOFA (Sepsis-related Organ Failure Assessment) score to describe organ dysfunction/failure. On behalf of the Working Group on Sepsis-Related Problems of the European Society of Intensive Care Medicine. Intensive Care Med. 1996;22(7):707-710. doi:10.1007/bf01709751
}
\examples{
sofa_score(80, 40, 1, 120, 1.5, 65, "medium", 13, 2.2)
}
