\name{slics_spine_score}
\alias{slics_spine_score}
\title{
Subaxial Cervical Spine Injury Classification System (SLICS)
}
\description{
Calculates the SLICS score to guide the management (operative vs. non-operative) of subaxial cervical spine injuries (C3-C7). The score is based on three main categories: injury morphology, discoligamentous complex (DLC) integrity, and neurological status.
}
\usage{
slics_spine_score(morphology, dlc_status, neurologic_status,
                  continuous_compression = 0)
}
\arguments{
  \item{morphology}{
String. The morphology of the injury.
Options:
"no_abnormality": 0 pts.
"compression": 1 pt.
"burst": 2 pts.
"distraction": 3 pts (e.g., facet perch, hyperextension).
"translation_rotation": 4 pts (e.g., facet dislocation, unstable teardrop).
}
  \item{dlc_status}{
String. Status of the Discoligamentous Complex (DLC).
Options:
"intact": 0 pts.
"indeterminate": 1 pt (e.g., isolated interspinous widening, MRI signal change only).
"disrupted": 2 pts (e.g., facet perch/dislocation, wide separation).
}
  \item{neurologic_status}{
String. Neurological status of the patient.
Options:
"intact": 0 pts.
"root_injury": 1 pt.
"complete_cord": 2 pts.
"incomplete_cord": 3 pts.
}
  \item{continuous_compression}{
Numeric (0 or 1). Is there continuous cord compression in the setting of a neurologic deficit? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{SLICS_Score}{The calculated total score (Range 0-10+).}
\item{Management_Recommendation}{Clinical guidance based on the score (Non-Operative < 4, Indeterminate = 4, Operative > 4).}
}
\references{
Vaccaro AR, Hulbert RJ, Patel AA, et al. The subaxial cervical spine injury classification system: a novel approach to recognize the importance of morphology, neurology, and integrity of the disco-ligamentous complex. Spine (Phila Pa 1976). 2007;32(21):2365-2374. doi:10.1097/BRS.0b013e3181557b92
}
\examples{

# Example 1: Non-Operative
# Burst fracture (2), Intact DLC (0), Intact Neuro (0)
# Score = 2
slics_spine_score("burst", "intact", "intact")

# Example 2: Operative
# Distraction (3), Disrupted DLC (2), Incomplete Cord (3)
# Score = 8
slics_spine_score("distraction", "disrupted", "incomplete_cord")
}
