\name{sic_score}
\alias{sic_score}
\title{
Sepsis-Induced Coagulopathy (SIC) Score
}
\description{
Calculates the Sepsis-Induced Coagulopathy (SIC) score to identify patients with sepsis who are developing coagulopathy. This score serves as an early warning system for Disseminated Intravascular Coagulation (DIC) and is useful for selecting patients for anticoagulant therapy trials in sepsis.
}
\usage{
sic_score(platelet_count, inr, sofa_total_score)
}
\arguments{
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L.
< 100: +2 pts.
100-150: +1 pt.
>= 150: 0 pts.
}
  \item{inr}{
Numeric. International Normalized Ratio.
> 1.4: +2 pts.
> 1.2 - 1.4: +1 pt.
<= 1.2: 0 pts.
}
  \item{sofa_total_score}{
Numeric. The total Sequential Organ Failure Assessment (SOFA) score.
>= 2: +2 pts.
1: +1 pt.
0: 0 pts.
}
}
\value{
A list containing:
\item{SIC_Score}{The calculated score (Range 0-6).}
\item{Classification}{"Sepsis-Induced Coagulopathy (SIC)" if Score >= 4, otherwise "No SIC".}
}
\references{
Iba T, Nisio MD, Levy JH, et al. New criteria for sepsis-induced coagulopathy (SIC) following the revised sepsis definition: a poster-hoc analysis of the FACS trial. Crit Care. 2017;21:209. doi:10.1186/s13054-017-1790-7
}
\examples{

# Example 1: SIC Present
# Plt 80 (2), INR 1.5 (2), SOFA 5 (2)
# Score = 6
sic_score(80, 1.5, 5)

# Example 2: No SIC
# Plt 160 (0), INR 1.1 (0), SOFA 3 (2)
# Score = 2
sic_score(160, 1.1, 3)
}
