\name{san_francisco_syncope_rule}
\alias{san_francisco_syncope_rule}
\title{
San Francisco Syncope Rule
}
\description{
Calculates the San Francisco Syncope Rule result to predict the risk of serious outcomes at 7 days in patients presenting with syncope. The rule uses the CHESS mnemonic: CHF history, Hematocrit < 30, ECG abnormal, Shortness of breath, and Systolic BP < 90. Presence of any single factor classifies the patient as High Risk.
}
\usage{
san_francisco_syncope_rule(history_chf, hematocrit, ecg_abnormal,
                           shortness_of_breath, systolic_bp)
}
\arguments{
  \item{history_chf}{
Numeric (0 or 1). History of Congestive Heart Failure. (1 = Yes).
}
  \item{hematocrit}{
Numeric. Hematocrit percentage. (< 30\% is a positive predictor).
}
  \item{ecg_abnormal}{
Numeric (0 or 1). Abnormal ECG (e.g., non-sinus rhythm or new changes). (1 = Yes).
}
  \item{shortness_of_breath}{
Numeric (0 or 1). History of shortness of breath. (1 = Yes).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure at triage in mmHg. (< 90 mmHg is a positive predictor).
}
}
\value{
A list containing:
\item{Risk_Classification}{"High Risk" (if any criteria met) or "Low Risk".}
\item{Criteria_Present}{List of specific positive predictors identified.}
\item{Test_Characteristics}{Sensitivity and Specificity metrics.}
}
\references{
Quinn J, McDermott D, Stiell I, Kohn M, Wells G. Prospective validation of the San Francisco Syncope Rule to predict patients with serious outcomes. Ann Emerg Med. 2006;47(5):448-454. doi:10.1016/j.annemergmed.2005.11.019
}
\examples{

# Example 1: High Risk (CHF history)
# Hx CHF (1), Hct 40, Normal ECG, No SOB, SBP 120
san_francisco_syncope_rule(1, 40, 0, 0, 120)

# Example 2: Low Risk
# No Hx, Hct 42, Normal ECG, No SOB, SBP 110
san_francisco_syncope_rule(0, 42, 0, 0, 110)

# Example 3: High Risk (Low Hct and Low BP)
# No Hx, Hct 25, Normal ECG, No SOB, SBP 85
san_francisco_syncope_rule(0, 25, 0, 0, 85)
}
