\name{rome_iv_functional_dyspepsia}
\alias{rome_iv_functional_dyspepsia}
\title{
Rome IV Diagnostic Criteria for Functional Dyspepsia
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Dyspepsia. Diagnosis requires one or both of the main syndromes (Postprandial Distress Syndrome or Epigastric Pain Syndrome) for at least 3 months, with onset at least 6 months ago, and no evidence of organic disease that explains the symptoms.
}
\usage{
rome_iv_functional_dyspepsia(postprandial_fullness, early_satiation,
                             epigastric_pain, epigastric_burning,
                             organic_disease_excluded, symptom_onset_ge_6_months,
                             symptoms_active_last_3_months)
}
\arguments{
  \item{postprandial_fullness}{
Numeric (0 or 1). Bothersome postprandial fullness (severe enough to impact usual activities) at least 3 days a week. (1 = Yes).
}
  \item{early_satiation}{
Numeric (0 or 1). Bothersome early satiation (severe enough to prevent finishing a regular-sized meal) at least 3 days a week. (1 = Yes).
}
  \item{epigastric_pain}{
Numeric (0 or 1). Bothersome epigastric pain (severe enough to impact usual activities) at least 1 day a week. (1 = Yes).
}
  \item{epigastric_burning}{
Numeric (0 or 1). Bothersome epigastric burning (severe enough to impact usual activities) at least 1 day a week. (1 = Yes).
}
  \item{organic_disease_excluded}{
Numeric (0 or 1). Exclusion of organic disease (e.g., peptic ulcer, cancer) via upper endoscopy. (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting classification (PDS, EPS, Overlap, or Not Met).}
}
\references{
Stanghellini V, Chan FK, Hasler WL, et al. Gastroduodenal Disorders. Gastroenterology. 2016;150:1380-1392. doi:10.1053/j.gastro.2016.02.011
}
\examples{

# Example 1: Postprandial Distress Syndrome (PDS)
# Fullness (1), Early Satiation (0), No pain/burning, Organic excluded, Chronic
rome_iv_functional_dyspepsia(1, 0, 0, 0, 1, 1, 1)

# Example 2: Epigastric Pain Syndrome (EPS)
# No fullness/satiation, Pain (1), Burning (0), Organic excluded, Chronic
rome_iv_functional_dyspepsia(0, 0, 1, 0, 1, 1, 1)

# Example 3: Overlap Dyspepsia
# Fullness (1), Pain (1), Organic excluded, Chronic
rome_iv_functional_dyspepsia(1, 0, 1, 0, 1, 1, 1)
}
