\name{rome_iv_functional_diarrhea}
\alias{rome_iv_functional_diarrhea}
\title{
Rome IV Diagnostic Criteria for Functional Diarrhea
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Diarrhea. Diagnosis requires the recurrent passage of loose or watery stools in more than 25\% of defecations, with hard or lumpy stools in less than 25\% of defecations, and criteria for Irritable Bowel Syndrome (IBS) are not met. Symptoms must have started at least 6 months ago and been active for the last 3 months.

[Image of bristol stool scale chart]

}
\usage{
rome_iv_functional_diarrhea(loose_watery_stool_ge_25_percent,
                            hard_lumpy_stool_lt_25_percent, meets_ibs_criteria,
                            symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{loose_watery_stool_ge_25_percent}{
Numeric (0 or 1). Are loose or watery stools (Bristol Stool Form 6-7) present in >25\% of bowel movements? (1 = Yes).
}
  \item{hard_lumpy_stool_lt_25_percent}{
Numeric (0 or 1). Are hard or lumpy stools (Bristol Stool Form 1-2) present in <25\% of bowel movements? (1 = Yes).
}
  \item{meets_ibs_criteria}{
Numeric (0 or 1). Does the patient meet diagnostic criteria for Irritable Bowel Syndrome (IBS), specifically regarding predominant abdominal pain? (1 = Yes). Note: Meeting IBS criteria excludes Functional Diarrhea.
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been present for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Diarrhea" or "Criteria Not Met".}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# Loose stools >25%, No hard stools, No IBS, Chronic
rome_iv_functional_diarrhea(1, 1, 0, 1, 1)

# Example 2: Not Met (Meets IBS)
# Loose stools present, but IBS pain criteria also met
rome_iv_functional_diarrhea(1, 1, 1, 1, 1)
}
