\name{renal_nephrometry_score}
\alias{renal_nephrometry_score}
\title{
RENAL Nephrometry Score
}
\description{
Calculates the RENAL Nephrometry Score to quantify the anatomical complexity of renal masses. This system aids in surgical decision-making (e.g., partial vs. radical nephrectomy) and outcomes prediction. The acronym stands for Radius, Exophytic/Endophytic, Nearness to collecting system, Anterior/Posterior, and Location relative to polar lines.
}
\usage{
renal_nephrometry_score(radius_cm, exophytic_percent, nearness_collecting_system_mm,
                        anterior_posterior, location_polar_lines)
}
\arguments{
  \item{radius_cm}{
Numeric. Radius (maximal diameter) of the tumor in centimeters.
<=4: 1 pt.
>4-<7: 2 pts.
>=7: 3 pts.
}
  \item{exophytic_percent}{
Numeric. Percentage of the tumor that is exophytic.
>=50\%: 1 pt.
<50\%: 2 pts.
Endophytic: 3 pts.
}
  \item{nearness_collecting_system_mm}{
Numeric. Distance of the tumor to the collecting system or sinus in millimeters.
>=7mm: 1 pt.
>4mm-<7mm: 2 pts.
<=4mm: 3 pts.
}
  \item{anterior_posterior}{
String. Location relative to the coronal plane. Options: "anterior" (a), "posterior" (p), "neither" (x).
}
  \item{location_polar_lines}{
String. Location relative to the polar lines.
"entirely_above_below": Entirely above upper or below lower polar line (1 pt).
"crosses_polar_line": Crosses polar line (2 pts).
"gt_50_percent_across_polar_line_or_axial": >50\% of mass is across polar line, or crosses axial renal midline, or entirely between polar lines (3 pts).
}
}
\value{
A list containing:
\item{RENAL_Score}{The formatted score (e.g., "4a", "10p").}
\item{Complexity_Level}{Classification (Low 4-6, Moderate 7-9, High 10-12).}
}
\references{
Kutikov A, Uzzo RG. The R.E.N.A.L. nephrometry score: a comprehensive standardized system for quantitating renal tumor size, location and depth. J Urol. 2009;182(3):844-853. doi:10.1016/j.juro.2009.05.035
}
\examples{

# Example 1: Low Complexity
# 3cm, 60% exophytic, 8mm from sinus, Anterior, Above polar line
# Score: 1+1+1+1 = 4a
renal_nephrometry_score(3, 60, 8, "anterior", "entirely_above_below")

# Example 2: High Complexity
# 5cm, Endophytic, Touching sinus (0mm), Posterior, Crossing midline
# Score: 2+3+3+3 = 11p
renal_nephrometry_score(5, 0, 0, "posterior", "gt_50_percent_across_polar_line_or_axial")
}
