\name{rasp_hiv_risk}
\alias{rasp_hiv_risk}
\title{
HIV Needle Stick Risk Assessment Stratification Protocol (RASP)
}
\description{
Estimates the risk of HIV transmission following occupational exposure (needle stick, mucous membrane, or non-intact skin contact) and provides Post-Exposure Prophylaxis (PEP) recommendations based on CDC guidelines.
}
\usage{
rasp_hiv_risk(source_status, exposure_type, deep_injury_or_visible_blood,
              source_viral_load_high)
}
\arguments{
  \item{source_status}{
String. Status of the source patient. Options: "positive", "negative", "unknown".
}
  \item{exposure_type}{
String. Type of exposure. Options: "percutaneous" (needle stick/cut), "mucous_membrane" (splash to eye/mouth), "non_intact_skin" (abrasion/dermatitis).
}
  \item{deep_injury_or_visible_blood}{
Numeric (0 or 1). Was the injury deep or was there visible blood on the device? (1 = Yes).
}
  \item{source_viral_load_high}{
Numeric (0 or 1). Is the source known to have a high viral load or acute HIV infection? (1 = Yes).
}
}
\value{
A list containing:
\item{Estimated_Transmission_Risk}{The estimated probability of seroconversion (e.g., 0.3\% for percutaneous).}
\item{PEP_Recommendation}{Guidance on initiating Post-Exposure Prophylaxis.}
}
\references{
Kuhar DT, Henderson DK, Struble KA, et al. Updated US Public Health Service Guidelines for the Management of Occupational Exposures to Human Immunodeficiency Virus and Recommendations for Postexposure Prophylaxis. Infect Control Hosp Epidemiol. 2013;34(9):875-892. doi:10.1086/672271
}
\examples{

# Example 1: High Risk Needlestick
# Source Positive, Percutaneous, Deep injury
rasp_hiv_risk("positive", "percutaneous", 1, 1)

# Example 2: Lower Risk Splash
# Source Positive, Mucous membrane splash
rasp_hiv_risk("positive", "mucous_membrane", 0, 0)

# Example 3: Source Negative
# No risk
rasp_hiv_risk("negative", "percutaneous", 1, 0)
}
