\name{rapid_acetabular_score}
\alias{rapid_acetabular_score}
\title{
RAPID Score for Acetabular Chondrolabral Disruption
}
\description{
Calculates the Rapidly Assessed Predictor of Intraoperative Damage (RAPID) score. This preoperative scoring system predicts the presence of high-grade acetabular labrum articular disruption (ALAD grade 3 or 4) in patients undergoing hip arthroscopy for femoroacetabular impingement.
}
\usage{
rapid_acetabular_score(sex, tonnis_grade, cam_morphology)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). Male sex adds 1 point.
}
  \item{tonnis_grade}{
Numeric (0-2). Tönnis classification of osteoarthritis.
0: No signs of OA (0 points).
1: Increased sclerosis, slight narrowing/lipping (+2 points).
2: Small cysts, moderate narrowing, loss of sphericity (+3 points).
Note: Grade 3 is a contraindication to arthroscopy and not scored.
}
  \item{cam_morphology}{
Numeric (0 or 1). Presence of Cam morphology, defined as an alpha angle > 55 degrees. (1 = Present/Yes, +1 point).
}
}
\value{
A list containing:
\item{RAPID_Score}{The calculated total score (Range 0-5).}
\item{Risk_Prediction}{Estimated probability of finding high-grade chondral damage intraoperatively.}
}
\references{
Nwachukwu BU, Chang B, Rotter B, et al. The Rapidly Assessed Predictor of Intraoperative Damage (RAPID) Score: An In-Clinic Predictive Model for High-Grade Acetabular Chondrolabral Disruption. Am J Sports Med. 2019;47(2):395-400. doi:10.1177/0363546518813091
}
\examples{

# Example 1: High Risk Candidate
# Male (+1), Tonnis Grade 1 (+2), Cam Present (+1)
# Score = 4
rapid_acetabular_score("male", 1, 1)

# Example 2: Low Risk Candidate
# Female (0), Tonnis Grade 0 (0), Cam Absent (0)
# Score = 0
rapid_acetabular_score("female", 0, 0)
}
